from ConfigParser import SafeConfigParser

__all__ = ["get_configdict_fromfile", ]


def readconfig(filename):
    config = SafeConfigParser()
    config.read(filename)
    return config


def get_config_dict(config):
    d = dict(config.items('database'))
    v = False

    if d.get('oeview.allow_echo', None):
        v = d['oeview.allow_echo']
        if v.lower() == 'false':
            v = False
        else:
            v = True
    d['oeview.allow_echo'] = v
    return d


def get_configdict_fromfile(filename):
    return get_config_dict(readconfig(filename))
