# -*- encoding: UTF-8 -*-
from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from oeview.model import Base


def get_sessionmaker(config):
    """return a session maker suitable for multithreaded
    use and bound to a configured engine based on your
    configuration.

    @param config: a dict like object
    @type config: dict

    @return: sqlalchemy.orm.sessionmaker instance
    """

    engine = create_engine(
        'postgres://%s:%s@%s:%s/%s' % (
            config.get('oeview.user'),
            config.get('oeview.password'),
            config.get('oeview.host'),
            config.get('oeview.port'),
            config.get('oeview.db'),
        ),
        echo=config.get('oeview.allow_echo'),
    )

    # bind our engine to the Base.metadata to ease future use
    Base.metadata.bind = engine

    return sessionmaker(bind=engine)
